package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.databinding.ObservableBoolean
import androidx.databinding.ObservableInt
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.activitesfragments.spaces.models.RoomModel
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.DiscoverModel
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.repositories.RoomRepository
import com.qboxus.tictic.repositories.ShopRepository
import com.qboxus.tictic.repositories.VideosRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class DiscoverViewModel(
    private val context: Context,
    private val videoRepository: VideosRepository,
    private val shopRepository: ShopRepository,
    private val roomRepository: RoomRepository

) : ViewModel(){

    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences=Functions.getSharedPreference(context)
    }


    var ispostFinsh = false
    var pageCount: ObservableInt = ObservableInt(0)



    val _videosLiveData: MutableLiveData<ApiResponce<ArrayList<DiscoverModel>>> = MutableLiveData()
    val videosLiveData: LiveData<ApiResponce<ArrayList<DiscoverModel>>> get() = _videosLiveData

    fun showDiscoverySections(){
        viewModelScope.launch {

            val params = JSONObject().apply {
                put("starting_point", pageCount.get().toString())

            }
            videoRepository.showDiscoverySections(params,_videosLiveData)
        }
    }


    val _shopsLiveData:MutableLiveData<ApiResponce<ArrayList<UserModel>>> = MutableLiveData()
    val shopsLiveData:LiveData<ApiResponce<ArrayList<UserModel>>> get() = _shopsLiveData
    fun showShops(){
        viewModelScope.launch {
            val params = JSONObject().apply {
                put("starting_point", pageCount.get().toString())
            }

            shopRepository.getShopsList(params,_shopsLiveData)
        }
    }


    val _RoomLiveData:MutableLiveData<ApiResponce<ArrayList<RoomModel>>> = MutableLiveData()
    val roomLiveData:LiveData<ApiResponce<ArrayList<RoomModel>>> get() = _RoomLiveData
    fun showRoom(){
        viewModelScope.launch {
            val params = JSONObject().apply {
                put("starting_point", pageCount.get().toString())
            }

            roomRepository.getRoomList(params,_RoomLiveData)
        }
    }

    var noDataLayoutVisibility = ObservableBoolean(false)
    var loadMoreProgressVisibility = ObservableBoolean(false)

    fun showNoDataView(){
        noDataLayoutVisibility.set(true)
    }

    fun showDataView(){
        noDataLayoutVisibility.set(false)
    }

}
